
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class Class : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.Class, BO.Class>
    {

        internal Class(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal Class(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.Class.DBD) { }

        internal BO.Class RestoreTopOne(BO.Class.Search Search)
        {
            return InternalRestoreOne((int)DBD.Class.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["InstructorID"].Value = Search.InstructorID;
                Command["Name"].Value = Search.Name;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["SchoolYearID"].Value = Search.SchoolYearID;
            });
        }

        internal List<BO.Class> Restore(BO.Class.Search Search)
        {
            return InternalRestoreList((int)DBD.Class.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["InstructorID"].Value = Search.InstructorID;
                Command["Name"].Value = Search.Name;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["SchoolYearID"].Value = Search.SchoolYearID;
            });
        }

        internal int Count(BO.Class.Search Search)
        {
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Class.Commands.CountBySearch,
                delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
                {
                    Command["InstructorID"].Value = Search.InstructorID;
                    Command["Name"].Value = Search.Name;
                    Command["SchoolID"].Value = Search.SchoolID;
                    Command["SchoolYearID"].Value = Search.SchoolYearID;
                });

            if (_command != null)
            {
                return Convert.ToInt32(_command["Result"].Value);
            }
            return 0;
        }

        internal bool Remove(BO.Class.Search Search)
        {
            bool _return = false;
            Gemini.Core.BL.Interface.DBD.ICommand _command = InternalExecuteScalar((int)DBD.Class.Commands.RemoveBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["InstructorID"].Value = Search.InstructorID;
                Command["Name"].Value = Search.Name;
                Command["SchoolID"].Value = Search.SchoolID;
                Command["SchoolYearID"].Value = Search.SchoolYearID;
                Command["EditDate"].Value = DateTime.Now;
                Command["EditUser"].Value = Environment.User.ID;
            });

            if (_command != null)
            {
                if (_command.ResultParam != null)
                {
                    _return = _command.ResultParamValue >= 0 ? true : false;
                }
                else
                {
                    _return = true;
                }
            }
            return _return;
        }
    }
}